<?php
/**
 * SISTEMA MULTI-SERVIDOR REFORÇADO 2026 - DASHBOARD INTEGRADO
 * STATUS: BLINDADO CONTRA LOGOUT ACIDENTAL E MEMORY LEAK
 */

ini_set('memory_limit', '512M'); 
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
session_start();

header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");

include 'config.php';
$json_file = './includes/dns/dns.json'; 

if (!is_dir('./includes/dns')) { 
    mkdir('./includes/dns', 0755, true); 
}

function get_json_data() {
    global $json_file;
    if (!file_exists($json_file)) { 
        file_put_contents($json_file, json_encode([], JSON_PRETTY_PRINT)); 
    }
    $content = file_get_contents($json_file);
    $data = json_decode($content, true);
    unset($content);
    return is_array($data) ? $data : [];
}

$json = get_json_data();
$notification = isset($_SESSION['notif']) ? $_SESSION['notif'] : '';
unset($_SESSION['notif']);

function save_json($data) {
    global $json_file;
    $encoded = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    return file_put_contents($json_file, $encoded);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action_performed = false;

    if (isset($_POST['add_server'])) {
        $serverName = trim($_POST['server_name']);
        $serverAddress = trim($_POST['server_address']);
        
        if (!empty($serverName) && !empty($serverAddress)) {
            $maxId = 0;
            foreach ($json as $key => $val) {
                if (preg_match('/server(\d+)_name/', $key, $matches)) {
                    $maxId = max($maxId, (int)$matches[1]);
                }
            }
            $nextId = $maxId + 1;
            $json["server{$nextId}_name"] = $serverName;
            $json["server{$nextId}"] = $serverAddress;
            if (save_json($json)) {
                $_SESSION['notif'] = 'Servidor adicionado!';
                $action_performed = true;
            }
        }
    }

    if (isset($_POST['delete_server'])) {
        $id = $_POST['delete_server'];
        unset($json[$id . '_name'], $json[$id]);
        if (save_json($json)) {
            $_SESSION['notif'] = 'Servidor removido!';
            $action_performed = true;
        }
    }

    if (isset($_POST['delete_all'])) {
        $clean_json = [];
        $keys_to_keep = ['sitename', 'username', 'password', 'default_color'];
        foreach($keys_to_keep as $k) { if(isset($json[$k])) $clean_json[$k] = $json[$k]; }
        if (save_json($clean_json)) {
            $_SESSION['notif'] = 'Lista limpa!';
            $action_performed = true;
        }
    }

    if (isset($_POST['edit_server'])) {
        $id = $_POST['server_index'];
        $json["{$id}_name"] = trim($_POST['edit_server_name']);
        $json[$id] = trim($_POST['edit_server_address']);
        if (save_json($json)) {
            $_SESSION['notif'] = 'Atualizado!';
            $action_performed = true;
        }
    }

    if ($action_performed) {
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }
}

$servidoresEmUso = 0;
foreach ($json as $key => $value) { if (strpos($key, '_name') !== false) $servidoresEmUso++; }
?>

<!DOCTYPE html>
<html lang="pt-br" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>DNS Manager</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        html { background-color: #09090b; }
        body { opacity: 0; transition: opacity 0.3s ease-in; }
        body.loaded { opacity: 1; }
        .modal-overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.85); backdrop-filter: blur(8px); z-index: 50; }
        .edit-modal { display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 100; }

        @media (max-width: 768px) {
            table, thead, tbody, th, td, tr { display: block; }
            thead tr { position: absolute; top: -9999px; left: -9999px; }
            tr { margin-bottom: 1rem; background: #111827; border-radius: 1rem; padding: 1rem; border: 1px solid #1f2937; }
            td { border: none; position: relative; padding: 0.5rem 0 !important; text-align: left !important; }
            td:nth-of-type(1) { font-size: 1.1rem; border-bottom: 1px solid #1f2937; margin-bottom: 0.5rem; color: #3b82f6; font-weight: bold; }
            td:last-child { display: flex; justify-content: flex-end; gap: 0.75rem; border-top: 1px solid #1f2937; padding-top: 1rem !important; }
        }
    </style>
</head>
<body class="bg-gray-100 dark:bg-gray-950 text-gray-800 dark:text-gray-200">

    <header class="h-16 bg-white dark:bg-gray-900 border-b border-gray-200 dark:border-gray-800 flex items-center justify-between px-4 md:px-6 sticky top-0 z-40">
        <div class="flex items-center gap-4">
            <h1 class="text-lg md:text-xl font-black bg-gradient-to-r from-blue-500 to-cyan-500 bg-clip-text text-transparent uppercase">DNS Manager</h1>
        </div>
        <div class="flex items-center gap-2 md:gap-4">
            <a href="dashboard.php" class="flex items-center gap-2 px-3 py-1.5 md:px-4 md:py-2 bg-gray-100 dark:bg-gray-800 hover:bg-gray-200 dark:hover:bg-gray-700 rounded-xl text-xs md:text-sm font-bold transition-all border border-gray-200 dark:border-gray-700">
                <span>🏠</span> <span class="hidden sm:inline">Dashboard</span>
            </a>
            <span class="hidden md:inline text-sm font-semibold opacity-70">Olá, <?= htmlspecialchars($_SESSION["username"]) ?></span>
        </div>
    </header>

    <div class="flex">
        <aside class="w-64 bg-white dark:bg-gray-900 h-[calc(100vh-4rem)] border-r border-gray-200 dark:border-gray-800 p-4 hidden md:block">
            <nav class="space-y-1">
                <a href="dashboard.php" class="flex items-center gap-3 p-3 rounded-xl hover:bg-gray-100 dark:hover:bg-gray-800 transition-all">🏠 Dashboard</a>
                <a href="servidores.php" class="flex items-center gap-3 p-3 rounded-xl bg-blue-600/10 text-blue-500 font-bold border border-blue-600/20">🖥️ Servidores</a>
                <a href="admin.php" class="flex items-center gap-3 p-3 rounded-xl hover:bg-gray-100 dark:hover:bg-gray-800 transition-all">👤 Admin</a>
                <a href="logoutvs.php" class="flex items-center gap-3 p-3 rounded-xl text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 transition-all">🚪 Sair</a>
            </nav>
        </aside>

        <main class="flex-1 p-4 md:p-6 overflow-y-auto">
            <div class="max-w-5xl mx-auto">
                
                <?php if ($notification): ?>
                <div id="notif" class="mb-6 p-4 bg-blue-600 text-white rounded-2xl shadow-xl flex items-center justify-between">
                    <div class="flex items-center gap-3 font-medium">✅ <?= $notification ?></div>
                    <button onclick="this.parentElement.remove()">✕</button>
                </div>
                <?php endif; ?>

                <div class="bg-white dark:bg-gray-900 rounded-3xl p-5 md:p-6 shadow-xl border border-gray-200 dark:border-gray-800 mb-8">
                    <h2 class="text-lg font-bold mb-4 flex items-center gap-2"><span>➕</span> Adicionar DNS</h2>
                    <form method="post" action="">
                        <div class="flex flex-col md:grid md:grid-cols-3 gap-3 md:gap-4">
                            <input type="text" name="server_name" placeholder="Nome do Servidor" class="bg-gray-50 dark:bg-gray-800 p-4 rounded-2xl border border-gray-200 dark:border-gray-700 focus:ring-2 ring-blue-500 outline-none transition-all" required>
                            <input type="text" name="server_address" placeholder="http://dominio.com:8080" class="bg-gray-50 dark:bg-gray-800 p-4 rounded-2xl border border-gray-200 dark:border-gray-700 focus:ring-2 ring-blue-500 outline-none transition-all" required>
                            <button type="submit" name="add_server" class="h-[56px] md:h-auto bg-blue-600 hover:bg-blue-700 text-white font-bold rounded-2xl shadow-lg shadow-blue-600/30 transition-all active:scale-[0.97] flex items-center justify-center gap-2">
                                💾 <span>Salvar Servidor</span>
                            </button>
                        </div>
                    </form>
                </div>

                <div class="flex justify-between items-center mb-4 px-2">
                    <h3 class="font-bold opacity-60 uppercase text-xs tracking-widest">Lista (<?= $servidoresEmUso ?>)</h3>
                    <?php if ($servidoresEmUso > 0): ?>
                    <form method="post" action="" onsubmit="return confirm('Apagar todos?')">
                        <button type="submit" name="delete_all" class="text-xs font-bold text-red-500 border border-red-500/30 px-3 py-2 rounded-xl">🗑️ Limpar</button>
                    </form>
                    <?php endif; ?>
                </div>

                <div class="bg-white dark:bg-gray-900 rounded-3xl shadow-xl border border-gray-200 dark:border-gray-800 overflow-hidden">
                    <table class="w-full text-left border-collapse">
                        <thead class="bg-gray-50 dark:bg-gray-800/50">
                            <tr>
                                <th class="p-5 text-xs font-bold uppercase opacity-50">Configuração</th>
                                <th class="p-5 text-xs font-bold uppercase opacity-50">Host</th>
                                <th class="p-5 text-center text-xs font-bold uppercase opacity-50">Ações</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 dark:divide-gray-800">
                            <?php foreach ($json as $key => $value): ?>
                                <?php if (strpos($key, '_name') !== false): 
                                    $id = str_replace('_name', '', $key); $addr = $json[$id] ?? '';
                                ?>
                                <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-800/30">
                                    <td class="p-5 font-bold text-blue-500"><?= htmlspecialchars($value) ?></td>
                                    <td class="p-5 font-mono text-sm opacity-80 break-all"><?= htmlspecialchars($addr) ?></td>
                                    <td class="p-5 text-center">
                                        <div class="flex justify-center gap-3">
                                            <button onclick="openEdit('<?= $id ?>', '<?= addslashes($value) ?>', '<?= addslashes($addr) ?>')" class="p-3 bg-gray-100 dark:bg-gray-800 rounded-xl min-w-[44px] min-h-[44px] flex items-center justify-center">✏️</button>
                                            <form method="post" action="" onsubmit="return confirm('Remover?')">
                                                <input type="hidden" name="delete_server" value="<?= $id ?>">
                                                <button type="submit" class="p-3 bg-red-100 dark:bg-red-900/30 text-red-500 rounded-xl min-w-[44px] min-h-[44px] flex items-center justify-center">🗑️</button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>

    <div id="overlay" class="modal-overlay" onclick="closeEdit()"></div>
    <div id="editForm" class="edit-modal w-[90%] max-w-md bg-white dark:bg-gray-900 p-6 md:p-8 rounded-3xl shadow-2xl border border-gray-200 dark:border-gray-800">
        <h3 class="text-xl font-bold mb-6">Ajustar DNS</h3>
        <form method="post" action="" class="space-y-4">
            <input type="hidden" id="edit_id" name="server_index">
            <input type="text" id="edit_name" name="edit_server_name" class="w-full p-4 bg-gray-50 dark:bg-gray-800 rounded-2xl border border-gray-200 dark:border-gray-700 outline-none" required>
            <input type="text" id="edit_addr" name="edit_server_address" class="w-full p-4 bg-gray-50 dark:bg-gray-800 rounded-2xl border border-gray-200 dark:border-gray-700 outline-none" required>
            <div class="flex gap-3">
                <button type="submit" name="edit_server" class="flex-1 bg-blue-600 p-4 rounded-2xl text-white font-bold active:scale-95 transition-all">Atualizar</button>
                <button type="button" onclick="closeEdit()" class="flex-1 bg-gray-100 dark:bg-gray-800 p-4 rounded-2xl font-bold">Voltar</button>
            </div>
        </form>
    </div>

    <script>
        window.addEventListener('load', () => document.body.classList.add('loaded'));
        function openEdit(id, name, addr) {
            document.getElementById('edit_id').value = id;
            document.getElementById('edit_name').value = name;
            document.getElementById('edit_addr').value = addr;
            document.getElementById('editForm').style.display = 'block';
            document.getElementById('overlay').style.display = 'block';
        }
        function closeEdit() {
            document.getElementById('editForm').style.display = 'none';
            document.getElementById('overlay').style.display = 'none';
        }
        setTimeout(() => { 
            const n = document.getElementById('notif');
            if(n) { n.style.transition = 'opacity 0.5s'; n.style.opacity = '0'; setTimeout(() => n.remove(), 500); }
        }, 3000);
    </script>
</body>
</html>